<?php
extract( shortcode_atts( array(
	'image' => '',
	'type' => '',
	'frame' => '',
	'image_link' => '',
	'open_new' => '',
	'css_animation' => '',
	'animation_delay' => '',
	'el_class' => '',
), $atts ) );

$image_url = wp_get_attachment_url( $image );
$image_title = get_the_title( $image );
$image_alt = get_post_meta( $image, '_wp_attachment_image_alt', true );
if ( empty( $image_alt ) ) $image_alt = $image_title;

$css_class = array( 'sm-slide-image', 'sm_content_element' );
$type = sm_validate_with_array( $type, sm_get_slide_image_types_array() );
$css_class[] = $type;
$frame = sm_validate_with_array( $frame, sm_get_slide_image_frames_array() );
$css_class[] = $frame;
$css_class = implode( ' ', $css_class );
$css_class .= sm_get_css_animation( $css_animation );
$css_class .= sm_get_extra_class( $el_class );

$wrapper_attributes = array();
$wrapper_attributes[] = 'class="' . esc_attr( $css_class ) . '"';

$a_attributes = array();
if ( !empty( $image_link ) ) {
	$a_attributes[] = 'href="' . $image_link . '"';
	if ( 'true' == $open_new ) {
		$a_attributes[] = 'target="_blank"';
	}
}

if ( intval( $animation_delay ) > 0 ) {
	$wrapper_attributes[] = sm_get_animation_delay_attribute( $animation_delay );
}
?>

<div <?php echo implode( ' ', $wrapper_attributes ); ?>>
	<div class="image-wrap">
	<?php if ( !empty( $a_attributes ) ) : ?><a <?php echo implode( ' ', $a_attributes ); ?>><?php endif;?>
		<div class="image-wrap-inner" style="background-image: url(<?php echo esc_url( $image_url ); ?>);">
			<img src="<?php echo esc_url( $image_url ); ?>" alt="<?php echo esc_attr( $image_alt ); ?>" title="<?php echo esc_attr( $image_title ); ?>" />
		</div>
	<?php if ( !empty( $a_attributes ) ) : ?></a><?php endif; ?>
	</div>
</div>
